package cn.quantgroup.xyqb.util;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/6/22 11:01
 * @description：过滤地址特殊符号
 * @modified By：
 * @version: 1.0
 */
public class AddressFilter {

    private static final List<Pattern> PATTERN_LIST = Lists.newArrayList();

    static {
        PATTERN_LIST.add(new Pattern("|", ""));
    }

    public static String filterAddress(String address) {

        if (!StringUtils.isNotEmpty(address)) {
            return address;
        }

        for (Pattern pattern : PATTERN_LIST) {
            address = StringUtils.replace(address, pattern.getTarget(), pattern.getReplaceMent());
        }

        return address;
    }

    @Getter
    @Setter
    @AllArgsConstructor
    public static class Pattern {
        private String target;
        private String replaceMent;
    }

}
