package wechat;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.repository.IWeChatUserRepository;
import cn.quantgroup.xyqb.service.user.IAddressService;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/5/27 10:55
 * @description：微信测试类
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class WechatTest {
    @Resource
    private IWeChatUserRepository weChatUserRepository;

    @Resource
    IAddressService iAddressService;


    @Test
    public void testQuery(){
        Address byUserId = iAddressService.findByUserId(58846805L);
        System.out.println(byUserId);
    }

    @Test
    public void test(){
        WechatUserInfo xyqb = weChatUserRepository.findByOpenIdAndAppName("ou5l71eY3oO0oM88I-fp3pfC9sQg", "xyqb");
        log.info("xyqb:{} ",xyqb);
        WechatUserInfo xyqb1 = weChatUserRepository.findByUserIdAndAppName(58847276L, "xyqb");
        log.info("xyqb1:{} ",xyqb1);
        WechatUserInfo xyqb2 = weChatUserRepository.findByPhoneNoAndAppName("13718195234", "xyqb");
        log.info("xyqb2:{} ",xyqb2);
        long xyqb3 = weChatUserRepository.countByOpenIdAndAppName("ou5l71eY3oO0oM88I-fp3pfC9sQg", "xyqb");
        log.info("xyqb3:{} ",xyqb3);

//        int xyqb4 = weChatUserRepository.dissociateByUserIdAndAppName(58847276L, "xyqb");
//        log.info("xyqb4:{} ",xyqb4);
        int i = weChatUserRepository.dissociateUser("ou5l71UOXLkIXNz0dtW1znJSTwR0", 58847276L, "xyqb");
        log.info("xyqb5:{} ",i);


    }

}
