package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.repository.IUserDetailRepository;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.vo.UserDetailVO;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.persistence.criteria.*;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by 11 on 2016/12/29.
 */
@Service
public class UserDetailServiceImpl implements IUserDetailService {

  @Autowired
  private IUserDetailRepository userDetailRepository;
  @Autowired
  private IUserRepository userRepository;

  @Override
  public UserDetail findByUserId(Long userId) {
    return userDetailRepository.findByUserId(userId);
  }

  @Override
  public UserDetail saveUserDetail(UserDetail userDetail) throws DataIntegrityViolationException {
    return userDetailRepository.save(userDetail);
  }

  @Override
  public UserDetail findByPhoneNo(String phoneNo) {
    return userDetailRepository.findByPhoneNo(phoneNo);
  }

  @Override
  public void updateUserQQ(Long userId, String qq) {
    userDetailRepository.updateUserQQ(qq, userId);
  }

  @Override
  public List<UserDetailVO> searchUserDetailList(String name, String phoneNo, String idNo) {
    // return
    List<UserDetail> details = userDetailRepository.findAll(getSpecification(name, phoneNo, idNo));
    Map<Long, User> userMap = Maps.newHashMap();
    if (!CollectionUtils.isEmpty(details)) {
      List<Long> userIds = details.stream().map(d -> d.getUserId()).collect(Collectors.toList());
      List<User> users = userRepository.findAll((root, query, cb) -> {
        query.where(root.get("id").in(userIds));
        return query.getRestriction();
      });
      userMap = users.stream().collect(Collectors.toMap(User::getId, o -> o));
    }
    Map<Long, User> finalUserMap = userMap;
    List<UserDetailVO> userDetailVOS = details.stream().map(o -> fromUserDetailAndUserMap(o, finalUserMap)).collect(Collectors.toList());
    return userDetailVOS;
  }

  private UserDetailVO fromUserDetailAndUserMap(UserDetail userDetail, Map<Long, User> userMap) {
    UserDetailVO userDetailVO = UserDetailVO.fromUserDetail(userDetail);
    User user = userMap.get(userDetail.getUserId());
    if (user != null) {
      userDetailVO.setEnable(user.getEnable());
    }
    return userDetailVO;
  }

  private Specification<UserDetail> getSpecification(String name, String phoneNo, String idNo) {
    Specification<UserDetail> specification = new Specification<UserDetail>() {
      @Override
      public Predicate toPredicate(Root<UserDetail> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        if (!StringUtils.isEmpty(name)) {
          Path<String> namePath = root.get("name");
          criteriaQuery.where(criteriaBuilder.equal(namePath, name));
        }
        if (!StringUtils.isEmpty(phoneNo)) {
          Path<String> phonePath = root.get("phoneNo");
          criteriaQuery.where(criteriaBuilder.equal(phonePath, phoneNo));
        }
        if (!StringUtils.isEmpty(idNo)) {
          Path<String> idNoPath = root.get("idNo");
          criteriaQuery.where(criteriaBuilder.equal(idNoPath, idNo));
        }
        return null;
      }
    };
    return specification;
  }
}
