package cn.quantgroup.xyqb.service.session.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;
import cn.quantgroup.xyqb.service.session.ISessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * Created by 11 on 2016/12/28.
 */
public class SessionServiceImpl implements ISessionService{

    public final int oneDay = 24 * 60 * 60;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Override
    public SessionStruct createSession(User user) {
        SessionStruct sessionStruct;
        //获取sessionid
        String sessionId = findSessionIdByUserId(user.getId());
        if(sessionId.length() == 36){
            sessionStruct = new SessionStruct();
            //TODO 不确定
            JsonResult result = findSessionValueBySessionId(sessionId);
            if(result != null){
                sessionStruct = newSession(user);
                PersistSession(sessionStruct.getSid(), sessionStruct.getValues());
            }
            sessionStruct.setSid(sessionId);
        }else {
            sessionStruct = newSession(user);
            PersistSession(sessionStruct.getSid(), sessionStruct.getValues());
        }
        return sessionStruct;
    }

    @Override
    public String findSessionIdByUserId(Long userId) {
        //TODO 暂时写死
        return stringRedisTemplate.opsForValue().get("userid-sessionvalue:cache:" + userId.toString());
    }

    @Override
    public JsonResult findSessionValueBySessionId(String sessionId){
        String result = stringRedisTemplate.opsForValue().get("userid-sessionvalue:cache:" + sessionId);
        if(result.length() == 0){
            return JsonResult.buildErrorStateResult("wrong session Id", null, 0001L);
        }
        return null;
    }

    @Override
    public SessionStruct newSession(User user){
        Timestamp now = new Timestamp(System.currentTimeMillis());
        SessionStruct sessionStruct = new SessionStruct();
        SessionValue sessionValue = new SessionValue();
        sessionStruct.setSid(UUID.randomUUID().toString());
        sessionValue.setCreatedAt(now);
        sessionValue.setLastAccessTime(now);
        sessionValue.setUser(user);
        Map<String, Object> values = new HashMap();
        sessionValue.setValues(values);
        sessionStruct.setValues(sessionValue);
        return sessionStruct;
    }

    public JsonResult PersistSession(String token, SessionValue sessionValue){
        Timestamp current = new Timestamp(System.currentTimeMillis());
        sessionValue.setLastAccessTime(current);
        String json = Constants.GSON.toJson(sessionValue);
        stringRedisTemplate.opsForValue().set("userid-sessionvalue:cache:" + token, json, oneDay);
        return JsonResult.buildSuccessResult("持久化session success.", null);
    }
}
