package cn.quantgroup.xyqb.service.session;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;

/**
 * Created by 11 on 2016/12/28.
 */
public interface ISessionService {

    /**
     * 更新session
     * 用户信息存在,更新session中的最后访问时间,重新写入缓存.
     * 存在则保存用户session信息,userId为uuid
     *
     * @param user - 登录用户
     * @param loginProperties - 登录参数
     * @return
     */
    AuthBean createSession(User user, LoginProperties loginProperties);

    SessionStruct createSessionAndPersist(User user, LoginProperties loginProperties);

    void persistSession(String token, SessionValue sessionValue);

    void deleteByUserId(long userId);

    void deleteUserCatch(User user);
}
