package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.sql.Timestamp;
import java.util.Random;

import static cn.quantgroup.xyqb.constant.UserConstant.USER_ERROR_OR_PASSWORD_ERROR;

/**
 * @author mengfan.feng
 * @time 2015-10-27 11:41
 */
@RestController
@RequestMapping("/app")
public class AppController implements IBaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(AppController.class);

  @Autowired
  private ISessionService sessionService;
  @Autowired
  private IUserService userService;
  @Autowired
  private ILkbUserService lkbUserService;
  @Autowired
  private IUserRepository userRepository;
  @Autowired
  private ISmsService smsService;

  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IIdCardService idCardService;
  @Autowired
  private IMerchantService merchantService;

  private final static Random random = new Random();

  /**
   * 第三方用户登录
   */
  @RequestMapping("/login")
  public JsonResult login(
      String phoneNo,
      @RequestParam(required = false, defaultValue = "1") Long registerFrom,
      @RequestParam(required = false, defaultValue = "1") Long channelId,
      String idNo, String name, String key, @RequestParam(required = false, defaultValue = "") String appChannel, HttpServletRequest request
  ) {
    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }

    String requestIp = IPUtil.getRemoteIP(request);
    LOGGER.info("第三方用户登录, loginFrom:{}, requestIp:{}", registerFrom, requestIp);
    User user = userService.findByPhoneInDb(phoneNo);
    if (user == null) {
      user = register(registerFrom, phoneNo, idNo, name, channelId);
    }
    if (user == null) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }
    Merchant merchant = merchantService.findMerchantByName(key);
    if (merchant == null) {
      return JsonResult.buildErrorStateResult("无效的商户", null);
    }
    LoginProperties loginProperties = new LoginProperties();
    loginProperties.setChannelId(channelId);
    loginProperties.setMerchantName(merchant.getName());
    loginProperties.setCreatedFrom(registerFrom);
    loginProperties.setAppChannel(appChannel);
    SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);
    AuthBean bean = new AuthBean();
    bean.setToken(sessionStruct.getSid());
    bean.setPhoneNo(phoneNo);
    LOGGER.info("第三方用户登录成功, loginFrom:{}, phoneNo:{},appChannel:{}", registerFrom, phoneNo, appChannel);
    return new JsonResult(bean);
  }

  /**
   * 第三方用户登录并返回用户信息
   */
  @RequestMapping("/login_super")
  public JsonResult loginSuper(
      String phoneNo,
      @RequestParam(required = false, defaultValue = "1") Long registerFrom,
      @RequestParam(required = false, defaultValue = "1") Long channelId,
      String idNo, String name, String key, @RequestParam(required = false, defaultValue = "") String appChannel, HttpServletRequest request
  ) {
    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }

    String requestIp = IPUtil.getRemoteIP(request);
    LOGGER.info("第三方用户登录, loginFrom:{}, requestIp:{}", registerFrom, requestIp);
    User user = userService.findByPhoneInDb(phoneNo);
    if (user == null) {
      user = register(registerFrom, phoneNo, idNo, name, channelId);
    }
    if (user == null) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }
    Merchant merchant = merchantService.findMerchantByName(key);
    if (merchant == null) {
      return JsonResult.buildErrorStateResult("无效的商户", null);
    }
    LoginProperties loginProperties = new LoginProperties();
    loginProperties.setChannelId(channelId);
    loginProperties.setMerchantName(merchant.getName());
    loginProperties.setCreatedFrom(registerFrom);
    loginProperties.setAppChannel(appChannel);
    SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);

    LoginInfo loginInfo = new LoginInfo();
    loginInfo.setUser(UserRet.getUserRet(user));
    loginInfo.setToken(sessionStruct.getSid());
    LoginInfo.LoginContext context = new LoginInfo.LoginContext();
    context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
    context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
    context.setAppChannel(appChannel);
    loginInfo.setLoginContext(context);

    LOGGER.info("第三方用户获取信息登录成功, loginFrom:{}, phoneNo:{},appChannel:{}", registerFrom, phoneNo, appChannel);
    return JsonResult.buildSuccessResult("", loginInfo);
  }


  /**
   * 注册新用户
   *
   * @return
   */
  private User register(Long registerFrom, String phoneNo, String idNo, String name, Long channelId) {

    String randomCode = String.valueOf(random.nextInt(899999) + 100000);

    String uuid = lkbUserService.registerApp(phoneNo, randomCode);
    Timestamp currentTime = new Timestamp(System.currentTimeMillis());

    LOGGER.info("第三方登录用户，保存 User");

    User user = new User();
    if (channelId == 222L) {
      user.setRegisteredFrom(channelId);
    } else {
      user.setRegisteredFrom(registerFrom);
    }
    //user.setRegisteredFrom(registerFrom);
    user.setUuid(uuid);
    user.setEnable(true);
    user.setPhoneNo(phoneNo);
    user.setPassword(PasswordUtil.MD5(randomCode + Constants.PASSWORD_SALT));
    user.setUpdatedAt(currentTime);
    user.setCreatedAt(currentTime);
    userRepository.saveAndFlush(user);

    if (registerFrom != 645L) {
      smsService.sendAfterRegister(phoneNo);
      LOGGER.info("第三方登录用户注册成功, registerFrom:{}, phoneNo:{}, 并且已发送短信通知", registerFrom, phoneNo);
    }

    if (StringUtils.isNotEmpty(idNo) && StringUtils.isNotEmpty(name)) {
      LOGGER.info("第三方登录用户，保存 UserDetail");

      IdCardInfo cardInfo;
      try {
        cardInfo = idCardService.getIdCardInfoWithExceptions(idNo);

        UserDetail userDetail = new UserDetail();
        userDetail.setIdNo(cardInfo.getIdNo());
        userDetail.setPhoneNo(phoneNo);
        userDetail.setName(name);
        userDetail.setIdType(IdType.ID_CARD);
        userDetail.setCreatedAt(currentTime);
        userDetail.setUpdatedAt(currentTime);
        userDetail.setUserId(user.getId());
        userDetail.setGender(cardInfo.getGender());
        userDetailService.saveUserDetail(userDetail);

        lkbUserService.userUpdate(user.getUuid(), name, idNo);
      } catch (Exception e) {
        LOGGER.error("保存 UserDetail 出现异常", e);
      }
    }

    return user;
  }

}
