package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.converter.PhoneEncryptConverter;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Date: 2019/11/4
 * Time: 下午2:15
 *
 * @author: yangrui
 */
@Data
@Entity
@Table(name = "user_modify_phone_no")
@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
public class ModifyPhoneNo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -7797532159380593454L;

    /**
     * user.id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 注册人真实姓名
     */
    private String name;

    /**
     * 注册人身份证件号
     */
    @Column(name = "id_card")
    private String idCard;

    /**
     * 原手机号码
     */
    @Column(name = "prev_phone_no")
    @Convert(converter = PhoneEncryptConverter.class)
    private String prevPhoneNo;

    /**
     * 新手机号码
     */
    @Column(name = "cur_phone_no")
    @Convert(converter = PhoneEncryptConverter.class)
    private String curPhoneNo;

    /**
     * 身份证正面
     */
    @Column(name = "id_card_face_url")
    private String idCardFaceUrl;

    /**
     * 身份证背面
     */
    @Column(name = "id_card_rear_url")
    private String idCardRearUrl;

    /**
     * 本人手持身份证照片
     */
    @Column(name = "id_card_hold_url")
    private String idCardHoldUrl;

    /**
     * 申请状态 0处理中; 1修改完成; 2不允许修改;
     */
    @Column(name = "apply_status")
    private Integer applyStatus;

    /**
     * 申请状态补充原因
     */
    @Column(name = "apply_status_reason")
    private String applyStatusReason;

    /**
     * 处理状态 0待人工处理 1待用户反馈结果 2已反馈
     */
    @Column(name = "processing_status")
    private Integer processingStatus;
}
