package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.converter.PhoneEncryptConverter;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * 用户表
 *
 * @author Miraculous
 * @date 2015年07月04日
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user", uniqueConstraints = @UniqueConstraint(columnNames = "phone_no"))
public class User extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 手机号
     */
    @Column(name = "phone_no")
    @Convert(converter = PhoneEncryptConverter.class)
    private String phoneNo;

    /**
     * password
     */
    @Column(name = "password")
    private String password;

    /**
     * 第一次用户来源 channel_id
     */
    @Column(name = "registered_from")
    private Long registeredFrom;

    /**
     * uuid
     */
    @Column(name = "uuid")
    private String uuid;

    /**
     * 是否禁用
     */
    @Column(name = "enable")
    private Boolean enable;

    /**
     * 是否有密码
     *
     * @return true/false
     */
    public boolean getHasPassword() {
        return Objects.nonNull(password) && !Objects.equals("", password);
    }

}
