package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.controller.external.user.InnerController;
import cn.quantgroup.xyqb.entity.Contact;
import cn.quantgroup.xyqb.repository.IContactRepository;
import cn.quantgroup.xyqb.service.user.IContactService;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.List;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Service
public class ContactServiceImpl implements IContactService {
  private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(ContactServiceImpl.class);
  @Autowired
  private IContactRepository contactRepository;

  @Override
  @Cacheable(value = "contact", key = "'contact' + #userId", unless = "#result == null or #result.size() == 0", cacheManager = "cacheManager")
  public List<Contact> findByUserId(Long userId) {
    return contactRepository.findByUserId(userId);
  }

  @Override
  public Contact findById(Long id) {
    return contactRepository.findOne(id);
  }

  @Override
  @CacheEvict(value = "contact", key = "'contact' + #contacts.get(0).userId", cacheManager = "cacheManager")
  public List<Contact> save(List<Contact> contacts) {
    return contactRepository.save(contacts);
  }

  @Override
  @CacheEvict(value = "contact", key = "'contact' + #contact.userId", cacheManager = "cacheManager")
  public Contact save(Contact contact) {
    return contactRepository.save(contact);
  }

  public Contact saveContact(String name, String phoneNo, Relation relation, Contact contact) {
    if (null != name) {
      contact.setName(name);
    }
    if (null != phoneNo) {
      contact.setPhoneNo(phoneNo);
    }
    if (null != relation) {
      contact.setRelation(relation);
    }
    LOGGER.info("修改前联系人信息:{}",contact);
    Timestamp now = new Timestamp(System.currentTimeMillis());
    contact.setUpdateAt(now);
    contact = save(contact);
    return contact;
  }
}
