package demo;

import static org.junit.jupiter.api.Assertions.assertEquals;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

/**
 * jUnit5风格参数化批量测试（用例）
 * @author renwc
 * @date 2018-01-05
 */
@Tag("Parameters")
public class ParametersJunit5Test {
	@ParameterizedTest
	@ValueSource(strings = { "racecar", "radar", "able was I ere I saw elba" })
	void palindromes(String candidate) {
		Assert.assertNotNull(candidate);
	}

	@Ignore("Not Ready to Run")
	@Test
	public void loginFast() {
		System.out.println("Not Ready to Run");
	}

	@DisplayName("My 1st JUnit 5 test! 😎")
	@org.junit.jupiter.api.Test
	public void myFirstTest(TestInfo testInfo) {
		assertEquals(2, Math.addExact(1, 1), "1 + 1 should equal 2");
		assertEquals("My 1st JUnit 5 test! 😎", testInfo.getDisplayName(), () -> "TestInfo is injected correctly");
	}
}