package cn.quantgroup.xyqb.controller.middleoffice.login;

import cn.quantgroup.xyqb.controller.middleoffice.common.VerifyTypeEnum;
import cn.quantgroup.xyqb.model.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 注册与登陆
 */
@Api(tags = "middle_office 注册与登录 API")
@Slf4j
@RestController
@RequestMapping("/middle_office/login")
public class LoginController {

    @Resource
    private ILoginModule loginModule;


    @ApiOperation(value = "loginFreeAuto", httpMethod = "POST", notes="loginFreeAuto")
    @PostMapping("/{type}")
    public JsonResult loginFreeAuto(@PathVariable VerifyTypeEnum type,
                                    @RequestParam(required = false, defaultValue = "false") Boolean autoReg,
                                    @RequestParam(required = false, defaultValue = "1") Long channelId,
                                    @RequestParam(required = false) String appChannel,
                                    @RequestParam(required = false) String wechatOpenId,
                                    @RequestParam String phoneNo,
                                    @RequestParam(required = false) String verify
    ) {
        LoginVo login = loginModule.login(type, autoReg, channelId, appChannel, wechatOpenId, phoneNo, verify);
        return JsonResult.buildSuccessResultGeneric(login);
    }

    @ApiOperation(value = "通过密码修改密码", httpMethod = "PATCH", notes="通过密码修改密码")
    @PatchMapping("/modify/pwd")
    public JsonResult modifyByPwd(String phoneNo, String password, String passwordNew) {
        loginModule.modifyPwd(VerifyTypeEnum.pwd, phoneNo, password, passwordNew);
        return JsonResult.buildSuccessResult();
    }

    @ApiOperation(value = "通过短信修改密码", httpMethod = "PATCH", notes="通过短信修改密码")
    @PatchMapping("/modify/sms")
    public JsonResult modifyBySms(String phoneNo, String password, String verificationCode) {
        loginModule.modifyPwd(VerifyTypeEnum.sms, phoneNo, password, verificationCode);
        return JsonResult.buildSuccessResult();
    }

}
