package cn.quantgroup.xyqb.controller.middleoffice.common.image;

import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 极验验证码认证
 */
@Component
public class GeeVerifyStrategy implements IImageVerifyStrategy {

    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    @Override
    public ImageVerifyTypeEnum strategyName() {
        return ImageVerifyTypeEnum.gt;
    }

    @Override
    public boolean verify(ImageDTO image) {
        //todo param valid
        Map<String, Object> result = geetestCaptchaService.validGeetestCaptcha(image.getUniqueKey(), image.getUserIp(),
                ClientType.valueByName(image.getClientType()), image.getChallenge(),
                image.getValidate(), image.getSeccode());
        return (Boolean) result.get("valid");
    }
}
