package cn.quantgroup.xyqb.event;

import java.util.Objects;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import cn.quantgroup.acolyte.buddhistscriptures.ingester.UserIngest;

/**
 * 发送到Kafka - 综合统计中心 - 登录
 *
 * @author renwc
 * @date 2018-07-03
 */
@Component
public class KafkaUserEventListener implements ApplicationListener<StatisticsEvent> {
    @Resource
    private UserIngest userIngest;
    @Value("${kafka.connect}")
    private String kafka_connect;
    @Value("${batch.size}")
    private int batch_size;
    @Value("${linger.ms}")
    private int linger_ms;
    @Value("${reconnect.backoff.ms}")
    private int reconnect_backoff_ms;
    @Value("${retry.backoff.ms}")
    private int retry_backoff_ms;
    @Value("${buffer.memory}")
    private int buffer_memory;
    @Value("${max.block.ms}")
    private int max_block_ms;

    @Override
    public void onApplicationEvent(StatisticsEvent event) {
        if(Objects.nonNull(event.getRegister())){
            userIngest.sendRegisterInfo(event.getRegister());
        }
        if(Objects.nonNull(event.getLogin())){
            userIngest.sendLoginInfo(event.getLogin());
        }
        if(Objects.nonNull(event.getUserRealInfo())){
            userIngest.sendUserRealInfo(event.getUserRealInfo());
        }
    }
}
