package cn.quantgroup.xyqb.controller.middleoffice.userext;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.middleoffice.userext.req.UserExtReq;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 用户扩展信息
 */
@RestController
@RequestMapping("/middle_office/user/ext")
public class UserExtController {

    @Resource
    private IUserInfoRepository userInfoRepository;


    @Resource
    private IUserService userService;

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    //todo 保存失败的各种场景。
    @PutMapping("/{userId}")
    public JsonResult ext(@PathVariable Long userId, @RequestBody UserExtReq userExtReq,@RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        if (userExtReq.getEmail() != null) {
            userInfoRepository.updateUserEmail(userExtReq.getEmail(),userId,tenantId);
        }
        if (userExtReq.getQq() != null) {
            userInfoRepository.updateUserQq( userExtReq.getQq(),userId,tenantId);
        }
        return JsonResult.buildSuccessResult();
    }


}
