package cn.quantgroup.xyqb.model;

import java.util.Optional;

/**
 * 验证码验证类型
 *
 * @author renwc
 * @date 2018-02-02
 */
public enum ClientType {
    APP("native"), H5("h5"), WEB("web");

    ClientType(String alias) {
        this.alias = alias;
    }

    private String alias;

    public String getAlias() {
        return this.alias;
    }

    public final static ClientType valueByName(String name) {
        name = Optional.ofNullable(name).orElse("").toLowerCase();
        switch (name) {
            case "app":
            case "native":
                return APP;
            case "h5":
                return H5;
            case "web":
                return WEB;
            default:
                return APP;
        }
    }

}
