package cn.quantgroup.xyqb.config.mq;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory.CacheMode;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xuran on 2017/9/7.
 */
@Configuration
public class RegisterMqConfig {
    @Value("${register.rabbitmq.queue}")
    private String queueName;
    @Value("${register.rabbitmq.exchange}")
    private String registerMqExchange;
    @Value("${register.rabbitmq.queue.qq_gdt}")
    private String queueName4Gdt;
    @Value("${register.rabbitmq.routing_key.qq_gdt}")
    private String routingKey4Gdt;
    @Value("${register.rabbitmq.exchange.qq_gdt}")
    private String exchange4Gdt;

    @Value("${register.rabbitmq.connection.host}")
    private String host;
    @Value("${register.rabbitmq.connection.port}")
    private Integer port;
    @Value("${register.rabbitmq.connection.user}")
    private String user;
    @Value("${register.rabbitmq.connection.password}")
    private String password;
    @Value("${register.rabbitmq.connection.virtual-host}")
    private String virtualHost;

    @Value("${registered.notify.black.hole.rabbitmq.connection.virtual-host}")
    private String BlackVirtualHost;

    @Value("${loanvest.rabbitmq.connection.virtual-host}")
    private String loanVirtualHost;

    @Value("${loanvest.rabbitmq.exchange}")
    private String loanVestExchange;

    @Value("${loanvest.rabbitmq.queue}")
    private String loanQueueName;
    @Primary
    @Bean(name = "loanVestQueue")
    public Queue loanVestQueue() {
        return new Queue(loanQueueName);
    }

    @Primary
    @Bean(name = "loanVestBinding")
    public Binding bindingLoanVest(@Qualifier("loanVestAmqpAdmin") AmqpAdmin loanVestAdmin, @Qualifier("loanVestQueue") Queue loanVestQueue, @Qualifier("loanVestExchange") FanoutExchange loanVestExchange) {
        Binding binding = BindingBuilder.bind(loanVestQueue).to(loanVestExchange);
        loanVestAdmin.declareBinding(binding);
        return binding;
    }
    @Primary
    @Bean(name = "rabbitTemplate")
    public RabbitTemplate loanVestTemplate(@Qualifier("vestFactory") ConnectionFactory vestFactory) {
        RabbitTemplate template = new RabbitTemplate(vestFactory);
        template.setExchange(loanVestExchange);
        return template;
    }

    @Primary
    @Bean(name = "loanVestAmqpAdmin")
    public AmqpAdmin loanVestAdmin(@Qualifier("vestFactory") ConnectionFactory vestFactory) {
        return new RabbitAdmin(vestFactory);
    }

    @Primary
    @Bean(name = "loanVestExchange")
    public FanoutExchange loanVestExchange() {
        return new FanoutExchange(loanVestExchange);
    }


    @Primary
    @Bean(name = "vestFactory")
    public ConnectionFactory vestFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(loanVirtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }



    @Bean(name = "registeredNotifyBlackHoleFactory")
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(BlackVirtualHost);
        connectionFactory.setPublisherReturns(true);
        connectionFactory.setPublisherConfirms(true);
        return connectionFactory;
    }

    @Bean(name = "registeredNotifyBlackHoleRabbitTemplate")
    public RabbitTemplate registeredNotifyBlackHoleRabbitTemplate(@Qualifier("registeredNotifyBlackHoleFactory") ConnectionFactory connectionFactory) {
        return new RabbitTemplate(connectionFactory);
    }


    @Bean(name = "registerMqFactory")
    public ConnectionFactory registerMqFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Bean(name = "registerMqAmqpAdmin")
    public AmqpAdmin registerMqAmqpAdmin(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
        return new RabbitAdmin(registerMqFactory);
    }

    @Bean(name = "registerMqExchange")
    public FanoutExchange registerMqExchange() {
        return new FanoutExchange(registerMqExchange);
    }

    @Bean(name = "registerMqQueue")
    public Queue registerMqQueue() {
        return new Queue(queueName);
    }

    @Bean(name = "registerMqBinding")
    public Binding registerMqBinding(@Qualifier("registerMqAmqpAdmin") AmqpAdmin registerMqAmqpAdmin, @Qualifier("registerMqQueue") Queue registerMqQueue, @Qualifier("registerMqExchange") FanoutExchange registerMqExchange) {
        Binding binding = BindingBuilder.bind(registerMqQueue).to(registerMqExchange);
        registerMqAmqpAdmin.declareBinding(binding);
        return binding;
    }

    @Bean(name = "registerRabbitTemplate")
    public RabbitTemplate registerTemplate(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
        RabbitTemplate template = new RabbitTemplate(registerMqFactory);
        template.setExchange(registerMqExchange);
        return template;
    }


    @Bean(name = "registerMqExchange4Gdt")
    public FanoutExchange registerMqExchange4Gdt() {
        return new FanoutExchange(exchange4Gdt);
    }

    @Bean(name = "registerMqQueue4Gdt")
    public Queue registerMqQueue4Gdt() {
        return new Queue(queueName4Gdt);
    }

    @Bean(name = "registerMqBinding4Gdt")
    public Binding registerMqBinding4Gdt(@Qualifier("registerMqAmqpAdmin") AmqpAdmin registerMqAmqpAdmin, @Qualifier("registerMqQueue4Gdt") Queue registerMqQueue4Gdt, @Qualifier("registerMqExchange4Gdt") FanoutExchange registerMqExchange4Gdt) {
        Binding binding = BindingBuilder.bind(registerMqQueue4Gdt).to(registerMqExchange4Gdt);
        registerMqAmqpAdmin.declareBinding(binding);
        return binding;
    }


    @Bean(name = "registerRabbitTemplate4Gdt")
    public RabbitTemplate registerTemplate4Gdt(@Qualifier("registerMqFactory") ConnectionFactory registerMqFactory) {
        RabbitTemplate template = new RabbitTemplate(registerMqFactory);
        template.setExchange(exchange4Gdt);
        return template;
    }

    @Bean(name = "commonConnectionFactory")
    public ConnectionFactory commonConnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setCacheMode(CacheMode.CHANNEL);
        //根据使用情况动态调整。
        connectionFactory.setChannelCacheSize(100);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost("/");
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Bean(name = "wechatRabbitTemplate")
    public RabbitTemplate wechatRabbitTemplate(@Qualifier("commonConnectionFactory") ConnectionFactory commonConnectionFactory) {
        RabbitTemplate rabbitTemplate =  new RabbitTemplate(commonConnectionFactory);
        rabbitTemplate.setMessageConverter(new Jackson2JsonMessageConverter());
        RabbitAdmin rabbitAdmin = new RabbitAdmin(commonConnectionFactory);
        String queueName = "wechat_bind";
        Map<String, Object> queueArgs = new HashMap<>();
        //数据 1 天有效期
        queueArgs.put("x-message-ttl", 24 * 60 * 60 * 1000);
        Queue wechatBind = new Queue(queueName, true, false, false, queueArgs);
        rabbitAdmin.declareQueue(wechatBind);
        rabbitTemplate.setRoutingKey(queueName);
        return rabbitTemplate;
    }

}
