package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.util.MqUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;


/**
 * 发mq, 目前只有数据可视化分析系统需要这个
 *
 * @author ag
 */
@Component
public class MQRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        if (!userRegisterParam.isSendSuccessMq()) {
            return;
        }
        Long channelId = userRegisterParam.getChannelId();
        String dimension = userRegisterParam.getDimension();
        User user = userRegisterParam.getUser();
        //拿不到user对象. 就是没注册了
        if (user == null) {
            return;
        }
        // 发送注册成功统计消息
        MqUtils.sendRegisterMessage(channelId, dimension, user);
    }
}
