package cn.quantgroup.xyqb.service.captcha.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.GeetestLogEntity;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.SettingType;
import cn.quantgroup.xyqb.repository.IGeetestLogRepository;
import cn.quantgroup.xyqb.service.captcha.IGeetestLogService;
import cn.quantgroup.xyqb.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

/**
 * @author xufei on 2018/1/30.
 */
@Service
@Slf4j
public class GeetestLogServiceImpl implements IGeetestLogService {
    private final IGeetestLogRepository geetestLogRepository;

    public GeetestLogServiceImpl(IGeetestLogRepository geetestLogRepository) {
        this.geetestLogRepository = geetestLogRepository;
    }

    @Override
    public Long saveGeetestLog(String phoneNo, String clientType, String settingType, Map<String, String> imgMap) {
        GeetestLogEntity geetestLogEntity = new GeetestLogEntity();
        geetestLogEntity.setPhoneNo(phoneNo);
        geetestLogEntity.setDataSource(ClientType.valueByName(clientType).ordinal());
        geetestLogEntity.setSetting(SettingType.valueByName(settingType).ordinal());
        geetestLogEntity.setChallenge(imgMap.getOrDefault("reChallenge", ""));
        geetestLogEntity.setCaptchaId(imgMap.getOrDefault("gt", ""));
        if (imgMap.containsKey(Constants.QG_CAPTCHA_INITDT)) {
            geetestLogEntity.setInitializeDt(DateUtils.convertDate(LocalDateTime.parse(imgMap.get(Constants.QG_CAPTCHA_INITDT))));
        }
        if (imgMap.containsKey(Constants.QG_CAPTCHA_REGISTERDT)) {
            geetestLogEntity.setRegisterDt(DateUtils.convertDate(LocalDateTime.parse(imgMap.get(Constants.QG_CAPTCHA_REGISTERDT))));
        }

        if (imgMap.containsKey(Constants.QG_CAPTCHA_REGISTERREDT)) {
            geetestLogEntity.setRegisterReDt(DateUtils.convertDate(LocalDateTime.parse(imgMap.get(Constants.QG_CAPTCHA_REGISTERREDT))));
        }
        geetestLogEntity = geetestLogRepository.saveAndFlush(geetestLogEntity);
        return geetestLogEntity.getId();
    }

    @Override
    @Transactional
    public void updateGeetestLog(String geetestLogId, String initializeDt, String registerDt, String registerReDt, Map<String, Object> result) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            GeetestLogEntity geetestLogEntity = geetestLogRepository.findOne(Long.parseLong(geetestLogId));
            if (geetestLogEntity != null) {
                if (StringUtils.isNotBlank(initializeDt) && StringUtils.isNotBlank(registerDt) && StringUtils.isNotBlank(registerReDt)) {
                    geetestLogEntity.setInitializeDt(simpleDateFormat.parse(initializeDt));
                    geetestLogEntity.setRegisterDt(simpleDateFormat.parse(registerDt));
                    geetestLogEntity.setRegisterReDt(simpleDateFormat.parse(registerReDt));
                }
                geetestLogEntity.setValidataDt((Date) result.get("validataDt"));
                geetestLogEntity.setValidataReDt((Date) result.get("validataReDt"));
                geetestLogEntity.setValidataResult(result.getOrDefault("validataResult", "").toString());
                geetestLogEntity.setValidataMethod(result.getOrDefault("validataMethod", "").toString());
                geetestLogRepository.save(geetestLogEntity);
            }
        } catch (Exception e) {
            log.error("修改极验验证二次验证失败--{}", e.getMessage());
        }
    }

    @Override
    public void updateByUidGeetestLog(Long geetestLogId, Long id) {
        try {
            GeetestLogEntity geetestLogEntity = geetestLogRepository.getOne(geetestLogId);
            geetestLogEntity.setUserId(id);
            geetestLogRepository.save(geetestLogEntity);
        } catch (Exception e) {
            log.error("修改极验验证用户userId失败--{}", e.getMessage());
        }
    }

    @Override
    public void executeTask() {
        try {
            Date dt = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(dt);
            c.add(Calendar.DATE, -180);
            dt = c.getTime();

            log.info("执行删除超过180天的极验日志记录--{}", dt);
            Timestamp ts = new Timestamp(dt.getTime());
            geetestLogRepository.deleteByCreatedAtIsBefore(ts);
        } catch (Exception e) {
            log.error("执行删除超过180天的极验即日记录--{}", e.getMessage());
        }
    }

    @Override
    public GeetestLogEntity getById(Long id) {
        return geetestLogRepository.findOne(id);
    }

}
