package cn.quantgroup.xyqb.filter;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by Miraculous on 15/7/5.
 * 支持跨域
 */
@Component
@Configuration
public class CrosFilter implements Filter {

  private static final Set<String> DISALLOWED_METHOD = new HashSet<>();

  static {
    DISALLOWED_METHOD.add("OPTIONS");
    DISALLOWED_METHOD.add("PUT");
    DISALLOWED_METHOD.add("DELETE");
  }

  @Value("${xyqb.filter.allowedOrigin}")
  private String allowedOrigin;
  @Value("${xyqb.filter.allowedHeaders}")
  private String allowedHeaders;

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {

  }

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain)
      throws IOException, ServletException {
    HttpServletResponse response = (HttpServletResponse) servletResponse;
    HttpServletRequest request = (HttpServletRequest) servletRequest;
    response.setHeader("Access-Control-Allow-Origin", allowedOrigin);
    response.setHeader("Access-Control-Allow-Methods", "POST, GET");
    response.setHeader("Access-Control-Allow-Headers", allowedHeaders);
    response.setHeader("Access-Control-Max-Age", "3600");
    if (DISALLOWED_METHOD.contains(request.getMethod())) {
      return;
    }
    filterChain.doFilter(servletRequest, servletResponse);
  }

  @Override
  public void destroy() {

  }

}
