package cn.quantgroup.xyqb.interceptors;

import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by Miraculous on 15/7/10.
 */
public class ChannelIdInterceptor implements HandlerInterceptor {

    private static final String CHANNEL_ID = "channelId";
    private static final String CREATED_FROM = "createdFrom";
    private static final String APP_CHANNEL = "appChannel";

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        String channelId = request.getParameter(CHANNEL_ID);
        if (channelId == null) {
            channelId = (String) request.getAttribute(CHANNEL_ID);
        }
        if (channelId != null) {
            request.getSession().setAttribute(CHANNEL_ID, channelId);
        }

        String createdFrom = request.getParameter(CREATED_FROM);
        if (createdFrom == null) {
            createdFrom = (String) request.getAttribute(CREATED_FROM);
        }
        if (createdFrom != null) {
            request.getSession().setAttribute(CREATED_FROM, createdFrom);
        }

        String appChannel = request.getParameter(APP_CHANNEL);
        if (appChannel == null) {
            appChannel = (String) request.getAttribute(APP_CHANNEL);
        }
        if (appChannel != null) {
            request.getSession().setAttribute(APP_CHANNEL, appChannel);
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) throws Exception {

    }
}
