package cn.quantgroup.xyqb.util.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Marker;

/**
 * Created by ocean on 2017/5/4.
 */
public class WithOutPhoneLoggingEvent implements ILoggingEvent {

  private static Pattern pattern = Pattern.compile("(?<!\\d)(?:(?:1[34578]\\d{9})|(?:861[34578]\\d{9}))(?!\\d)");

  private ILoggingEvent event;

  transient String withOutPhoneFormattedMessage;

  public WithOutPhoneLoggingEvent(ILoggingEvent event){
    this.event = event;
  }

  @Override public String getThreadName() {
    return this.event.getThreadName();
  }

  @Override public Level getLevel() {
    return this.event.getLevel();
  }

  @Override public String getMessage() {
    return this.event.getMessage();
  }

  @Override public Object[] getArgumentArray() {
    return this.event.getArgumentArray();
  }

  @Override public String getFormattedMessage() {
    if (withOutPhoneFormattedMessage != null) {
      return withOutPhoneFormattedMessage;
    }
    //todo 用正则找到手机号，并打上掩码，替换进去
    //withOutPhoneFormattedMessage = event.getFormattedMessage();
    withOutPhoneFormattedMessage = coverPhone(event.getFormattedMessage());
    return withOutPhoneFormattedMessage;
  }

  @Override public String getLoggerName() {
    return this.event.getLoggerName();
  }

  @Override public LoggerContextVO getLoggerContextVO() {
    return this.event.getLoggerContextVO();
  }

  @Override public IThrowableProxy getThrowableProxy() {
    return this.event.getThrowableProxy();
  }

  @Override public StackTraceElement[] getCallerData() {
    return this.event.getCallerData();
  }

  @Override public boolean hasCallerData() {
    return this.event.hasCallerData();
  }

  @Override public Marker getMarker() {
    return this.event.getMarker();
  }

  @Override public Map<String, String> getMDCPropertyMap() {
    return this.event.getMDCPropertyMap();
  }

  @Override public Map<String, String> getMdc() {
    return this.event.getMdc();
  }

  @Override public long getTimeStamp() {
    return this.event.getTimeStamp();
  }

  @Override public void prepareForDeferredProcessing() {
    this.getFormattedMessage();
    this.getThreadName();
    // fixes http://jira.qos.ch/browse/LBCLASSIC-104
    this.getMDCPropertyMap();
  }

  private static String coverPhone(String str){
    if(str.length()<=0)
      return "";
    Matcher matcher = pattern.matcher(str);
    Map<String,String> replaceMap = new HashMap<>();
    while (matcher.find()) {
      String group = matcher.group();
      String replace = group.substring(0,3).concat("****").concat(group.substring(7));
      replaceMap.put(group,replace);
    }
    Set<Map.Entry<String, String>> entries = replaceMap.entrySet();
    for (Map.Entry<String, String> entry :entries){
      str = str.replaceAll(entry.getKey(),entry.getValue());
    }
    return str;
  }
}
