package cn.quantgroup.xyqb.aspect.lock;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用redis进行锁<br/>
 * 如果上一个请求正在处理会抛出throw ResubmissionException<br/>
 * Created by Feng on 2017/6/6.
 */
@Documented
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RedisLock {

    /**
     * 指定 lock key ;指定value后， key\prefix 设置将无效；
     * 默认为：方法名+":"+参数hash
     * @return
     */
    String value() default "";

    /**
     * 指定业务 key ;  默认为参数hash；可以是 SPEL表达式从参数中取值:(ex: #this[0].id - 第一个参数ID... )
     * ;最终lock key 为 prefix +":"+ key
     * @return
     */
    String key() default "";

    /**
     * 指定前缀  默认为 方法名；最终lock key 为 prefix +":"+ key
     * @return
     */
    String prefix() default "";

    /**
     * 锁等待时间 默认  10 * 1000 ms
     * @return
     */
    int timeout() default 10 * 1000;//

    /**
     * 锁超时时间 默认 60 * 1000 ms
     * @return
     */
    int expire() default 60 * 1000;//

}
