package cn.quantgroup.xyqb.controller.external.queryLog;
import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserQueryLog;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserQueryInfo;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IAddressService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserQueryLogService;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by zenglibin on 17/06/13.
 */
@RestController
@RequestMapping("/query")
public class UserQueryLogController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserQueryLogController.class);

  @Autowired
  private IUserQueryLogService userQueryLogService;
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IAddressService addressService;

  @Value("${xyqb.paycenter.url}")
  private String payCenterUrl;
  @Value("${xyqb.paycenter.id}")
  private String payCenterId;

  @Autowired
  private IHttpService httpService;

  @RequestMapping("/queryLog")
  public JsonResult queryLog(Date beginDate,Date endDate,Long pageId,Long pageSize) {

      List<UserQueryLog> userQueryLogs=userQueryLogService.findByTimestamp(beginDate,endDate,pageId-1,pageSize);
      return JsonResult.buildSuccessResult("查询成功",userQueryLogs);
  }

  @RequestMapping("/queryUserInfo")
  public JsonResult queryForResult(String key,String keyValues,String userName, String columns,Long pageId,Long pageSize) {

    //columns=>  userId,phoneNo,idNo,bankCard,address
    //key=>phoneNo、idNo、userId
    //checkKeysType;

    String[] values=keyValues.split(";");
    List<String> queryV= Arrays.asList(values);
    List<UserQueryInfo> userQueryInfos=new ArrayList<UserQueryInfo>();
    List<UserDetail> userDetails=new ArrayList<UserDetail>();
    List<Address> addresslist=new ArrayList<Address>();
    if(key.equals("userId")){
      List<Long> userIds=new ArrayList<Long>();
      for(String s:queryV){
        long uid=Long.valueOf(s);
        userIds.add(uid);
      }
      userDetails=userDetailService.findByUserIdIn(userIds);
    }else if(key.equals("phoneNo")){
      userDetails=userDetailService.findByPhoneNos(queryV);
    }else if(key.equals("idNo")){
      userDetails=userDetailService.findByIdnos(queryV);
    }

    if(columns.contains("bankCard")){
      //需加银行卡信息
    }

    if(columns.contains("address")){
      List<Long> uidss=new ArrayList<Long>();
      //加地址信息
      for(UserDetail ud:userDetails){
        uidss.add(ud.getUserId());
      }
      if(uidss!=null&&uidss.size()>0){
        addresslist=addressService.findByUserIds(uidss);
      }

    }

    //转换userDetail to userQueryInfo
    for(UserDetail ud:userDetails){
      UserQueryInfo uqi=new UserQueryInfo();
      if(columns.contains("idNo")){
        uqi.setIdNo(ud.getIdNo());
      }
      if(columns.contains("phoneNo")){
        uqi.setPhoneNo(ud.getPhoneNo());
      }
      if(columns.contains("userId")){
        uqi.setUserId(ud.getUserId());
      }
      if(columns.contains("address")){
        Optional<Address> oad=addresslist.stream().filter(addr->addr.getUserId()==ud.getUserId()).findFirst();
        if(oad.isPresent()){
          uqi.setAddress(oad.get().toString());
        }
      }
      userQueryInfos.add(uqi);

    }

    //保存记录
    UserQueryLog log=new UserQueryLog();
    log.setQueryItems(columns);
    log.setResultAmount(Long.valueOf(userQueryInfos.size()));
    log.setQueryCondition(key);
    log.setQueryDetail(keyValues);
    log.setLoginUserName(userName);
    if(keyValues!=null&&keyValues.length()<=2048){
      log.setQueryDetail(keyValues);
    }else{
      log.setQueryDetail(keyValues.substring(0,2048));
    }
    userQueryLogService.save(log);


    return JsonResult.buildSuccessResult("成功",userQueryInfos);
  }

  private String getBankCardsByPhoneNos(String phoneNo){

//    HashMap<String, String> parameters = new HashMap<>();
//    parameters.put("phoneNo", phoneNo);
//    parameters.put("merchantId", payCenterId);
//    //访问用户中心查询用户银行卡接口
//    String resultStr = httpService.post(payCenterUrl + "ex/common_bank_card/list", parameters);
//    StringBuffer cardList=null;
//    try{
//      JsonObject obj = new JsonParser().parse(resultStr).getAsJsonObject();
//      if(obj.get("data")!=null){
//        JsonArray array = obj.get("data").getAsJsonArray();
//        for(JsonElement jsonElement : array){
//          JsonObject jo = jsonElement.getAsJsonObject();
//          String cardNo=jo.get("cardNo").getAsString();
//          cardList.append(cardNo+",");
//        }
//      }
//
//    }catch(Exception e){
//
//    }
//    return cardList.toString();
    return null;
  }
}
