package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserQueryLog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

/**
 * Created by 11 on 2016/12/30.
 */
public interface IUserQueryLogRepository extends JpaRepository<UserQueryLog, Long> {
  List<UserQueryLog> findByCreatedAt(Timestamp date);

  @Transactional
  @Modifying
  @Query(nativeQuery=true,value = "select * from user_query_log ul where created_At between ?1 and ?2  limit ?3 ,?4 ")
  List<UserQueryLog> findQueryLogCreatedAt(Date beginDate, Date endDate,Long pageId,Long pageSize);
}
