package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.repository.IAddressRepository;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;

/**
 * Created by liqing on 2017/12/5 0005.
 * 注册 - 地址信息
 * 失败影响注册流程
 */
@Component("addressUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class AddressUserRegisterHandler extends AbstractUserRegisterHandler {

    @Autowired
    private IAddressRepository addressRepository;

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) {
        Address address = userRegisterParam.getAddress();
        User user = userRegisterParam.getUser();
        address.setUserId(user.getId());
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        address.setCreatedAt(currentTime);
        address.setUpdateAt(currentTime);
        addressRepository.save(address);
        if (successor != null){
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }
}
