package cn.quantgroup.xyqb.controller.external.captcha;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import java.util.*;

import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * 类名称：ImgCaptchaController
 * 类描述：图形验证码控制器
 *
 * @author 李宁
 * @version 1.0.0 创建时间：15/11/17 11:49 修改人： 修改时间：15/11/17 11:49 修改备注：
 */
@RestController
@RequestMapping("/api")
public class ImageCaptchaController {

  private static final String IMAGE_FORMAT_PNG = "png";
  private static final String IMG_BASE64_PATTREN = "data:image/" + IMAGE_FORMAT_PNG + ";base64,%s";

  @Autowired
  @Qualifier("customCaptchaService")
  private AbstractManageableImageCaptchaService imageCaptchaService;

  /**
   * 获取验证码
   * 默认匹配 GET /captcha, 提供4位数字和字母混合图片验证码
   */
  @RequestMapping(value = "/captcha")
  public JsonResult fetchCaptcha(HttpServletRequest request) {
    String imageId = UUID.randomUUID().toString();
    BufferedImage challenge = imageCaptchaService.getImageChallengeForID(Constants.IMAGE_CAPTCHA_KEY + imageId, request.getLocale());
    ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
    try {
      boolean write = ImageIO.write(challenge, IMAGE_FORMAT_PNG, jpegOutputStream);
    } catch (IOException e) {
      e.printStackTrace();
      return JsonResult.buildErrorStateResult("", "fail");
    }

    String imageBase64 = Base64.encodeBase64String(jpegOutputStream.toByteArray());

    Map<String, String> data = new HashMap<>();
    data.put("imageId", imageId);
    data.put("image", String.format(IMG_BASE64_PATTREN, imageBase64));
    return JsonResult.buildSuccessResult("", data);
  }

}
