package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.entity.enumerate.*;
import com.sun.org.apache.xpath.internal.operations.Bool;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/12/30.
 */
@Data
@Entity
@Table(name = "user_ext_info")
public class UserExtInfo implements Serializable {

    private static final long serialVersionUID = -1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Long id;
    @Column(name = "user_id")
    private Long userId;
    @Column(name = "means_of_income_payment")
    private IncomeEnum incomeEnum = IncomeEnum.UNKNOWN;
    @Column(name = "monthly_income_range")
    private IncomeRangeEnum incomeRangeEnum = IncomeRangeEnum.UNKNOWN;
    @Column(name = "occupation")
    private OccupationEnum occupationEnum = OccupationEnum.UNKNOWN;
    @Column(name = "education")
    private EducationEnum educationEnum = EducationEnum.UNKNOWN;
    @Column(name = "has_car")
    private Boolean hasCar = false;
    @Column(name = "has_social_security")
    private Boolean hasSocialSecurity = false;
    @Column(name = "has_house")
    private Boolean hasHouse = false;
    @Column(name = "has_credit_card")
    private Boolean hasCreditCard = false;
    @Column(name = "marry_status")
    private MaritalStatus marryStatus = MaritalStatus.UNKNOWN;
    @Column(name = "created_at")
    private Timestamp createdAt;
    @Column(name = "updated_at")
    private Timestamp updateAt;

}
