package common;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import cn.quantgroup.xyqb.util.ValidationUtil;

@Slf4j
@RunWith(JUnit4.class)
public class TestJdk8 {

    @Test
    public void testString() {
        String userIds = "1,2;3,4;5, ,  ;6";
        log.info("userIds:{}", userIds);
        String formatUserIds = ValidationUtil.filterNumbers(userIds);
        log.info("formatUserIds:{}", formatUserIds);
        Assert.assertTrue(formatUserIds, ValidationUtil.validateNumbers(formatUserIds));
        List<String> userIdStrList = Arrays.asList(formatUserIds.split(",|;"));
        log.info("userIdStrList:{}", userIdStrList);
        List<Long> userIdList = userIdStrList.stream().map(userId -> Long.valueOf(userId)).collect(Collectors.toList());
        log.info("userIdList:{}", userIdList);
        assert true;
    }

}
