package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserDetail;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author mengfan.feng
 * @time 2015-09-11 11:22
 */
public interface IUserDetailRepository extends JpaRepository<UserDetail, Long> {

  UserDetail findByUserId(Long userId);

  UserDetail findByPhoneNo(String phone);

  @Transactional
  @Modifying
  @Query(value = "update user_detail set qq = ?1 where user_id = ?2", nativeQuery = true)
  void updateUserQQ(String qq, Long userId);

  List<UserDetail> findAll(Specification<UserDetail> specification);

}
