package cn.quantgroup.xyqb.model;

import lombok.Builder;
import lombok.Data;

/**
 *  生成行为验证码的时候，
 */
@Data
public class BehaviorCodeBean {
    /**
     * 1:极验，2: 量化派图形验证码
     * 当客户端给的是极验，但是由于极验不可用的时候，会返回降级量化派图形验证码
     */
    private Integer type;
    private QtCode qtCode;
    private GeetestCode geetestCode;

    private String id;

    @Data
    @Builder
    public static class QtCode {
        private String imageData;
    }

    @Data
    @Builder
    public static class GeetestCode{
        /**
         * 流水号，一次完整验证流程的唯一标识
         */
        private String challenge;
        /**
         * 向极验申请的账号id
         */
        private String gt;
        private String reChallenge;
        /**
         * 新版验证码标识，固定不变
         */
        private boolean newCaptcha;

        private boolean offline;

    }
}
