package cn.quantgroup.xyqb.config.data;

import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.WechatAppNameMapping;
import cn.quantgroup.xyqb.model.WechatConfigBean;
import com.alibaba.fastjson.JSONArray;
import com.ctrip.framework.apollo.ConfigService;
import lombok.Getter;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;

@Component
@Getter
public class WechatConfiguration {

    //private final List<WechatConfigBean> list;
    //private final List<WechatAppNameMapping> wechatAppNameMappingList;

    public List<WechatConfigBean> getWechatConfig() {
        String data = ConfigService.getAppConfig().getProperty("wechat.configs", "[]");
        List<WechatConfigBean> list = JSONArray.parseArray(data, WechatConfigBean.class);
        return list;
    }

    public List<WechatAppNameMapping> appNameMappingList() {
        String data2 = ConfigService.getAppConfig().getProperty("wechat.appName.mapping", "[]");
        List<WechatAppNameMapping> wechatAppNameMappingList = JSONArray.parseArray(data2, WechatAppNameMapping.class);
        return wechatAppNameMappingList;
    }

    //变更为在以下代码中实时获取
    /*public WechatConfiguration() {
        String data = ConfigService.getAppConfig().getProperty("wechat.configs", "[]");
        list = JSONArray.parseArray(data, WechatConfigBean.class);
        String data2 = ConfigService.getAppConfig().getProperty("wechat.appName.mapping", "[]");
        wechatAppNameMappingList = JSONArray.parseArray(data2, WechatAppNameMapping.class);
    }*/



    public WechatConfigBean getByAppIdAndTenantId(String appId, Integer tenantId) {
        List<WechatConfigBean> list = getWechatConfig();
        Optional<WechatConfigBean> optional = list.stream().filter(i -> i.getAppId().equals(appId) && i.getTenantId().equals(tenantId)).findFirst();
        if (!optional.isPresent()) {
            throw new BizException(BizExceptionEnum.ERROR_WECHAT_APP_ID);
        } else {
            return optional.get();
        }
    }

    public WechatConfigBean getDefault() {
        List<WechatConfigBean> list = getWechatConfig();
        return list.stream().filter(WechatConfigBean::isDefaultMini).findFirst().get();
    }

    public WechatAppNameMapping getByAppName(String appName) {
        List<WechatAppNameMapping> wechatAppNameMappingList = appNameMappingList();
        Optional<WechatAppNameMapping> optional = wechatAppNameMappingList.stream().filter(i -> i.getAppName().equals(appName)).findFirst();
        if (!optional.isPresent()) {
            throw new BizException(BizExceptionEnum.ERROR_WECHAT_APP_ID);
        } else {
            return optional.get();
        }
    }


}
