package cn.quantgroup.xyqb.controller.middleoffice.user;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.event.DisableActiveEvent;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.TenantUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.qiniu.util.Json;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 用户信息
 */
@Slf4j
@RestController("middleUserController")
@RequestMapping("/middle_office/user")
public class UserController implements IBaseController {

    @Resource
    private IUserService userService;

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;


    @Autowired
    private ISessionService sessionService;

    @PutMapping("/enable/{userId}")
    public JsonResult enable(@PathVariable Long userId , @RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        User user = userService.findById(userId,tenantId);
        if (user == null) {
            //todo 用户不存在，怎么处理
            return JsonResult.buildSuccessResult();
        }
        user.setEnable(true);
        userService.saveUser(user);
        //通知消息中心
        applicationEventPublisher.publishEvent(new DisableActiveEvent(this, user));
        return JsonResult.buildSuccessResult();
    }

    @PutMapping("/disable/{userId}")
    public JsonResult disable(@PathVariable Long userId , @RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        User user = userService.findById(userId,tenantId);
        if (user == null) {
            //todo 用户不存在，怎么处理
            return JsonResult.buildSuccessResult();
        }
        user.setEnable(false);
        //清理缓存
        userService.saveUser(user);
        // 清除token缓存
        /* 清空session */
        sessionService.deleteByUserId(user.getId(),tenantId);
        //通知消息中心
        applicationEventPublisher.publishEvent(new DisableActiveEvent(this, user));

        return JsonResult.buildSuccessResult();
    }

    @GetMapping("/userId/{userId}")
    public JsonResult user(@PathVariable Long userId , @RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        User user = userService.findById(userId,tenantId);
        //TODO convert to userVO
        return JsonResult.buildSuccessResultGeneric(user);
    }


    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult user(@PathVariable String phoneNo , @RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        User user = userService.findByPhoneInDb(phoneNo,tenantId);
        //TODO convert to userVO
        return JsonResult.buildSuccessResultGeneric(user);
    }

    @GetMapping("/uuid/{uuid}")
    public JsonResult uuid(@PathVariable String uuid , @RequestHeader(value = Constants.X_AUTH_TENANT,defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        User user = userService.findByUuidWithCache(uuid,tenantId);
        //TODO convert to userVO
        return JsonResult.buildSuccessResultGeneric(user);
    }

    /**
     * 根据uuid或者userids 获取用户信息
     * @yapi http://yapi.quantgroups.com/project/17/interface/api/29902
     * @param params
     * @return
     */
    @PostMapping("/getByUuidsOrUserIds")
    public JsonResult getByUuidsOrUserIds(@RequestBody Map<String, Object> params) {
        log.info("根据uuid或者userids 获取用户信息 {}", params);
        List<String> vals = (List<String>) params.get("vals");
        Integer type = (Integer) params.get("type");
        String tenantIdStr = String.valueOf(params.getOrDefault("tenantId", TenantUtil.TENANT_DEFAULT));
        Integer tenantId = TenantUtil.TENANT_DEFAULT;
        if (!tenantIdStr.equals("")) {
            tenantId = Integer.valueOf(String.valueOf(params.getOrDefault("tenantId", TenantUtil.TENANT_DEFAULT)));
        }

        if (type == null || (type != 1 && type != 2)) {
            return JsonResult.buildErrorStateResult("type错误", null);
        }
        if (vals.size() > 500) {
            vals = vals.subList(0,500);
        }
        //默认羊小咩租户
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            tenantId = TenantUtil.TENANT_DEFAULT;
        }
        return JsonResult.buildSuccessResultGeneric(userService.findByUuidsOrUserIds(vals, type, tenantId));
    }

    /**
     * 清除用户sessionToken
     * 用于临时处理APP线上问题，强制用户退出
     */
    @PostMapping("/delUserSession")
    public JsonResult delUserSession(@RequestBody Map<String, Object> params) {
        Integer tenantId = getTenantId();
        Object userIdObj = params.get("userIdList");
        List<Long> userIdList = JSONObject.parseObject(userIdObj.toString(),new TypeReference<List<Long>>(){});
        for (Long userId : userIdList) {
            sessionService.deleteByUserId(userId,tenantId);
        }
        return JsonResult.buildSuccessResult();
    }
}
