package cn.quantgroup.xyqb.util;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import org.apache.commons.lang.StringUtils;

import java.util.Calendar;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Miraculous on 15/7/6.
 * 所有validate为真返回true， 否则返回false
 */
public class ValidationUtil {

  private static String phoneRegExp = "^((13[0-9])|(14[0-9])|(15[0-9])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$";
  private static String chineseNameRegExp = "^[\u4e00-\u9fa5]+(\\.|·)?[\u4e00-\u9fa5]+$";
  private static String ipv4RegExp = "^((2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?)\\.){3}(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?)$";
  private static String localIpv4RegExp = "^172(\\.(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?)){3}$";

  private static Pattern phonePattern = Pattern.compile(phoneRegExp);
  private static Pattern chinesePattern = Pattern.compile(chineseNameRegExp);
  private static Pattern ipv4Pattern = Pattern.compile(ipv4RegExp);
  private static Pattern localIpv4Pattern = Pattern.compile(localIpv4RegExp);

  public static boolean validatePhoneNo(String phoneNo) {
    boolean lengthValid = StringUtils.isNotEmpty(phoneNo) && phoneNo.length() == 11 && StringUtils.isNumeric(phoneNo);
    if (!lengthValid) {
      return false;
    }
    Matcher matcher = phonePattern.matcher(phoneNo);
    return matcher.find();
  }

  public static boolean validateChinese(String chinese) {
    if (StringUtils.isBlank(chinese)) {
      return false;
    }
    Matcher matcher = chinesePattern.matcher(chinese);
    return matcher.find();
  }

  public static boolean validateIpv4(String ipv4) {
    if (StringUtils.isBlank(ipv4)) {
      return false;
    }
    Matcher matcher = ipv4Pattern.matcher(ipv4);
    return matcher.find();
  }

  public static boolean validateLocalIpv4(String localIpv4) {
    if (StringUtils.isBlank(localIpv4)) {
      return false;
    }
    Matcher matcher = localIpv4Pattern.matcher(localIpv4);
    return matcher.find();
  }

  /**
   * 验证密令
   * 私钥 + 操作 + 时
   * @param key - Md5密令
   * @param lock - true or false
   * @return
   */
  public static boolean isValid(String key, boolean lock) {
    Calendar today = Calendar.getInstance();
    int hour_24 = today.get(Calendar.HOUR_OF_DAY);
    StringBuilder _key = new StringBuilder();
    _key.append(Constants.CLEAR_LOCK_FOR_IPV4_KEY).append(lock).append(hour_24);
    return Objects.equals(key, MD5Util.build(_key.toString()));
  }

  public static boolean isAtDangerousTime() {
    Calendar now = Calendar.getInstance();
    int hour = now.get(Calendar.HOUR_OF_DAY);
    return Constants.DANGEROUS_TIME_START <= hour || hour < Constants.DANGEROUS_TIME_END;
  }

  public static boolean validateChannelId(Long channelId) {
    return channelId == 0L ? false : true;
  }

  public static boolean isNull(Object object) {
    if (object == null) {
      return true;
    }
    return false;
  }

}
