package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserSpouse;
import cn.quantgroup.motan.enums.MaritalStatus;
import lombok.Data;

/**
 * Created by 11 on 2017/4/19.
 */
@Data
public class UserSpouseRet {

  private Long userId;

  private String spousePhone;

  private String spouseName;

  private Long createdAt;

  private Long updateAt;

  private MaritalStatus status;

  public static UserSpouseRet getUserSpouseRet(UserSpouse userSpouse) {
    if (userSpouse == null) {
      return null;
    }
    UserSpouseRet ret = new UserSpouseRet();
    ret.setUserId(userSpouse.getUserId());
    ret.setSpouseName(userSpouse.getSpouseName());
    ret.setSpousePhone(userSpouse.getSpousePhone());
    if (userSpouse.getUpdateAt() != null) {
      ret.setUpdateAt(userSpouse.getUpdateAt().getTime());
    }
    if (userSpouse.getCreatedAt() != null) {
      ret.setCreatedAt(userSpouse.getCreatedAt().getTime());
    }
    ret.setStatus(userSpouse.getStatus());
    return ret;
  }
}
