package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.util.HashUtil;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Data
@Entity
@Table(name = "user_hash_mapping")
@NoArgsConstructor
public class UserHashMapping extends BaseEntity implements Serializable {
    private static final long serialVersionUID = -1L;

    public UserHashMapping(Long userId) {
        this.userId = userId;
    }

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no_md5")
    private String phoneNoMd5;

    @Column(name = "id_no_md5")
    private String idNoMd5;

    @Column(name = "phone_no_md5_short")
    private Long phoneNoMd5Short;

    @Column(name = "id_no_md5_short")
    private Long idNoMd5Short;

    public void setPhoneNoMd5(String phoneNoMd5) {
        this.phoneNoMd5 = phoneNoMd5;
        this.phoneNoMd5Short = HashUtil.crc32(phoneNoMd5);
    }

    public void setIdNoMd5(String idNoMd5) {
        this.idNoMd5 = idNoMd5;
        this.idNoMd5Short = HashUtil.crc32(idNoMd5);
    }
}