package cn.quantgroup.xyqb.model;

import java.util.Optional;

/**
 * 验证码验证类型
 * @author renwc
 * @date 2018-02-02
 */
public enum ClientType {
  WEB, APP, H5;

  public final static ClientType valueByName(String name) {
    name = Optional.ofNullable(name).orElse("").toLowerCase();
    switch (name){
      case "app":
        return APP;
      case "h5":
        return H5;
      case "web":
        return WEB;
      default:
        return APP;
    }
  }

}
