package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.repository.IAddressRepository;
import cn.quantgroup.xyqb.repository.IUserExtInfoRepository;
import cn.quantgroup.xyqb.service.user.IAddressService;
import cn.quantgroup.xyqb.service.user.IUserExtInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Service
public class AddressServiceImpl implements IAddressService {

    @Autowired
    private IAddressRepository addressRepository;

    @Override
    @Cacheable(value = "addresscache", key = "'address' + #userId", unless = "#result == null", cacheManager = "cacheManager")
    public Address findByUserId(Long userId) {
        return addressRepository.findByUserId(userId);
    }

}
