package cn.quantgroup.xyqb.aspect.forbidden;

import cn.quantgroup.xyqb.exception.AccessForbiddenException;
import cn.quantgroup.xyqb.util.IpUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Aspect
@Component
@Slf4j
public class AccessForbiddenAspect {
    @Pointcut("@annotation(cn.quantgroup.xyqb.aspect.forbidden.AccessForbiddenValidator)")
    public void pointCutAt() {
    }

    @Before("pointCutAt()")
    private void before() throws Throwable {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        log.info("访问已下线接口, url={}, clientIp={}", request.getRequestURI(), IpUtil.getRemoteIP(request));
        throw new AccessForbiddenException("禁止访问，接口已下线");
    }
}
