package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.UserTag;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.ApplicationEvent;

/**
 * @author ：hongzhi
 */

@Getter
@Setter
public class UserLoginEvent extends ApplicationEvent {

    private UserTag userTag;
    private String geetestId;
    /**
     * 是否首次注册新用户
     */
    private Boolean register = false;

    public UserLoginEvent(Object source) {
        super(source);
    }

    public UserLoginEvent(Object source, UserTag userTag) {
        super(source);
        this.userTag = userTag;
    }
    public UserLoginEvent(Object source, UserTag userTag, String geetestId) {
        super(source);
        this.userTag = userTag;
        this.geetestId = geetestId;
    }

    public UserLoginEvent(Object source, UserTag userTag, String geetestId, boolean register) {
        super(source);
        this.userTag = userTag;
        this.geetestId = geetestId;
        this.register = register;
    }
}
