package cn.quantgroup.xyqb.config;

import cn.quantgroup.xyqb.util.DefaultSequencer;
import cn.quantgroup.xyqb.util.IdentitySequencer;
import cn.quantgroup.xyqb.util.ServerUtils;
import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.SensorsAnalytics;
import com.sensorsdata.analytics.javasdk.consumer.BatchConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

import java.io.IOException;

/**
 * Created by hechao on 2020/1/22.
 */
@Configuration
@EnableConfigurationProperties
public class AutoConfiguration {

    @Autowired
    private Environment environment;

    @EnableConfigurationProperties
    class Sequencer {

        @Bean
        @ConditionalOnMissingBean
        public IdentitySequencer identitySequencer(SequencerProperties sequencerProperties) throws Exception {
            Integer integerPort = ServerUtils.getIntegerPort(environment);
            Long workId = null;
            if (integerPort != null) {
                workId = integerPort.longValue();
            }
            if (workId == null) {
                throw new IllegalArgumentException("server port is null.");
            }
            workId = ServerUtils.getLongHostAddress() ^ integerPort;
            return new DefaultSequencer(workId, sequencerProperties);
        }
    }

    @Value("${sc.url}")
    private String dataUrl;

    @Bean(destroyMethod = "shutdown")
    public ISensorsAnalytics init() throws IOException {
//            //本地日志模式（此模式会在指定路径生成相应的日志文件）
//            return new SensorsAnalytics(new ConcurrentLoggingConsumer("/Users/hongzhi/scEvent/"));
        //网络批量发送模式（此模式在容器关闭的时候，如果存在数据还没有发送完毕，就会丢失未发送的数据！！！）
        return new SensorsAnalytics(new BatchConsumer(dataUrl));
    }

}