package cn.quantgroup.xyqb.util;

import org.springframework.security.crypto.bcrypt.BCrypt;

import java.util.Objects;

/**
 * Created by Miraculous on 15/7/5.
 */
public class BctyptPasswordUtil {
    public static String BCryptWithSalt(String password) {
        if(Objects.isNull(password)){
            return null;
        }
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public static Boolean BCryptCheckPw(String password, String hashe) {
        return BCrypt.checkpw(password, hashe);
    }

}
