package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.Address;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.repository.IAddressRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

/**
 * 注册成功后保存地址
 *
 * @author ag
 */
//@Component
public class AddressRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Autowired
    private IAddressRepository addressRepository;

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        Address address = userRegisterParam.getAddress();
        if (address == null) {
            return;
        }
        User user = userRegisterParam.getUser();
        address.setUserId(user.getId());
        addressRepository.save(address);
    }
}
