package cn.quantgroup.xyqb.controller.phonenoidno;

import cn.quantgroup.xyqb.entity.UserHashPhoneNoIdNoMapping;
import cn.quantgroup.xyqb.util.encrypt.Md5Util;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * 同步xyqb_user.user_detail
 * <p>
 * Date: 2019/12/13
 * Time: 上午10:42
 *
 * @author: yangrui
 */
@Slf4j
@RestController
@RequestMapping("/v1/phonenoidno")
public class UserHashPhoneNoIdNoMappingController {

    private static final String SYNC_DATA_PHONE_NO_ID_NO = "syncdataphonenoidno";
    private static final String SYNC_DATA_PHONE_NO_ID_NO_SWITCH = "switch";
    private static final String SYNC_DATA_PHONE_NO_ID_NO_LAST_ID = "last_id";

    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private JdbcTemplate jdbcTemplate;

    /**
     * md5(phone_no，id_no)
     * 本地环境模拟-Xms3G -Xmx3G，单线程同步实际时间45分钟
     *
     * @return
     */
    @GetMapping("/sync/data")
    public String syncData() {
        log.info("start");
        long start = System.currentTimeMillis();
        long idStart = 0;
        Object lastIdObj = stringRedisTemplate.opsForHash().get(SYNC_DATA_PHONE_NO_ID_NO, SYNC_DATA_PHONE_NO_ID_NO_LAST_ID);
        if (lastIdObj != null) {
            idStart = Long.valueOf(String.valueOf(lastIdObj));
        }
        final int limit = 5000;
        long count = jdbcTemplate.queryForObject("select count(id) from user_detail where id > ?", Long.class, new Object[]{idStart});
        if (count > 0) {
            long page = count / limit + 1;
            for (int i = 0; i < page; i++) {
                Object state = stringRedisTemplate.opsForHash().get(SYNC_DATA_PHONE_NO_ID_NO, SYNC_DATA_PHONE_NO_ID_NO_SWITCH);
                if (state == null || "on".equals(state)) {
                    List<UserHashPhoneNoIdNoMapping> userHashPhoneNoIdNoMappings = Lists.newArrayList();
                    jdbcTemplate.query("select id, user_id, phone_no, id_no" +
                            " from user_detail where id > ? limit ?", new Object[]{idStart, limit}, new RowCallbackHandler() {
                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            UserHashPhoneNoIdNoMapping userHashPhoneNoIdNoMapping = new UserHashPhoneNoIdNoMapping();
                            /* 暂存 */
                            userHashPhoneNoIdNoMapping.setId(rs.getLong("id"));
                            userHashPhoneNoIdNoMapping.setUserId(rs.getLong("user_id"));
                            userHashPhoneNoIdNoMapping.setPhoneNoIdNoMd5(Md5Util.build((rs.getString("phone_no") + rs.getString("id_no")).toLowerCase()));
                            userHashPhoneNoIdNoMappings.add(userHashPhoneNoIdNoMapping);
                        }
                    });
                    // TODO: 2019/12/13 rewriteBatchedStatements=true
                    if (CollectionUtils.isNotEmpty(userHashPhoneNoIdNoMappings)) {
                        jdbcTemplate.batchUpdate("insert ignore into user_hash_phone_no_id_no_mapping (user_id, phone_no_id_no_md5) values (?,?)", new BatchPreparedStatementSetter() {
                            @Override
                            public void setValues(PreparedStatement ps, int i) throws SQLException {
                                UserHashPhoneNoIdNoMapping userHashPhoneNoIdNoMapping = userHashPhoneNoIdNoMappings.get(i);
                                ps.setLong(1, userHashPhoneNoIdNoMapping.getUserId());
                                ps.setString(2, userHashPhoneNoIdNoMapping.getPhoneNoIdNoMd5());
                            }

                            @Override
                            public int getBatchSize() {
                                return userHashPhoneNoIdNoMappings.size();
                            }
                        });
                        idStart = userHashPhoneNoIdNoMappings.get(userHashPhoneNoIdNoMappings.size() - 1).getId();
                        stringRedisTemplate.opsForHash().put(SYNC_DATA_PHONE_NO_ID_NO, SYNC_DATA_PHONE_NO_ID_NO_LAST_ID, String.valueOf(idStart));
                    }
                }
            }
        }
        log.info("done cost time = 【{}】", System.currentTimeMillis() - start);
        return "SUCCESS";
    }

    @GetMapping("/sync/data/stop")
    public String syncDataStop() {
        stringRedisTemplate.opsForHash().put(SYNC_DATA_PHONE_NO_ID_NO, SYNC_DATA_PHONE_NO_ID_NO_SWITCH, "off");
        return "SUCCESS";
    }

    @GetMapping("/sync/data/open/switch")
    public String syncDataOpenSwitch() {
        stringRedisTemplate.opsForHash().put(SYNC_DATA_PHONE_NO_ID_NO, SYNC_DATA_PHONE_NO_ID_NO_SWITCH, "on");
        return "SUCCESS";
    }
}
