package cn.quantgroup.xyqb.controller.internal.login;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserRet;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created by Miraculous on 2016/12/30.
 */
@RestController
@RequestMapping("/auth")
public class AuthInfoController implements IBaseController {


  @Value("${xyqb.auth.url}")
  private String xyqbAuthUrl;

  @Autowired
  private IHttpService httpService;

  @Autowired
  private IUserService userService;


  @RequestMapping("/info/login")
  public JsonResult loginInfo() {
    SessionStruct sessionStruct = getCurrentSessionFromRedis();
    if(null != sessionStruct) {
      LoginInfo loginInfo = new LoginInfo();
      loginInfo.setUser(UserRet.getUserRet(sessionStruct.getValues().getUser()));
      loginInfo.setToken(sessionStruct.getSid());
      LoginInfo.LoginContext context = new LoginInfo.LoginContext();
      context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
      context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
      context.setAppChannel(sessionStruct.getValues().getLoginProperties().getAppChannel());
      loginInfo.setLoginContext(context);
      return JsonResult.buildSuccessResult("", loginInfo);  //有ThreadLocal不释放的问题，不可再使用原来方式了
    }else {
      // 函谷关去查token 返回值高仿
      HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
      String token = request.getHeader("x-auth-token");
      if(StringUtils.isBlank(token) ||token.length() != 36){
        return JsonResult.buildErrorStateResult("用户未登录",null);
      }
      String checkUrl = xyqbAuthUrl+"/innerapi/is_login";
      ImmutableMap<String, String> headMap = ImmutableMap.of("x-auth-token", token);
      String response = httpService.get(checkUrl, headMap, null);

      JsonResult result = JSONObject.parseObject(response, JsonResult.class);
      if (result == null || !"0000".equals(result.getCode()) || !"0000".equals(result.getBusinessCode())) {
        return JsonResult.buildErrorStateResult("用户未登录",null);
      }
      String phoneNo = ((Map<String, String>) result.getData()).get("phoneNo");
      User user = userService.findByPhoneWithCache(phoneNo);
      LoginInfo loginInfo = new LoginInfo();
      loginInfo.setUser(UserRet.getUserRet(user));
      loginInfo.setToken(token);
      LoginInfo.LoginContext context = new LoginInfo.LoginContext();
      context.setChannelId(null);
      context.setCreatedFrom(user.getRegisteredFrom());
      context.setAppChannel("");
      loginInfo.setLoginContext(context);
      return JsonResult.buildSuccessResult("", loginInfo);
    }
  }

}
