package web;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import demo.BaseParametersTest;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Optional;

/**
 * 业务层测试用例
 * @author renwc
 * @date 2018-01-05
 */
@Slf4j
@Rollback
@Transactional
@RunWith(value = SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class, webEnvironment= SpringBootTest.WebEnvironment.RANDOM_PORT)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class UserAuthorizedControllerTest extends BaseParametersTest {

    @Resource
    private TestRestTemplate restTemplate;
    private UserAuthorizedParam obj = new UserAuthorizedParam();
    {
        String userUuid = "711892ae-191b-445a-a4eb-3c0b7bab7840";
        String idNo = "350504198805144101";
        String name = "史书一";
        AuthPattern authPattern = AuthPattern.ZMXY;
        Boolean available = true;
        obj.setUserUuid(userUuid);
        obj.setIdNo(idNo);
        obj.setName(name);
        obj.setAuthPattern(Optional.ofNullable(authPattern).orElse(AuthPattern.ZMXY).name());
    }

    @Test
    public void testExist() throws Exception {
        ResponseEntity<String> phil = restTemplate.getForEntity("/user/auth/{model}?idNo={idNo}", String.class, "hasUserAuthorized", obj.getIdNo());
        log.info("testExist: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getAuthPattern());
        Assert.assertEquals(phil.getStatusCode(), HttpStatus.OK);
    }

    @Test
    public void testSave() throws Exception {
        ResponseEntity<String> phil = restTemplate.postForEntity("/user/auth/{model}", this.obj, String.class, "createUserAuthorized");
        log.info("testSave: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getAuthPattern());
        Assert.assertEquals(phil.getStatusCode(), HttpStatus.OK);
    }

    @Test
    public void testQuery(){
        ResponseEntity<String> phil = restTemplate.getForEntity("/user/auth/{model}?userUuid={userUuid}", String.class, "getUserAuthorizedId", obj.getUserUuid());
        Assert.assertEquals(phil.getStatusCode(), HttpStatus.OK);
    }

}
