package common;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.util.AesUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import cn.quantgroup.xyqb.util.ValidationUtil;

@Slf4j
@RunWith(JUnit4.class)
public class Jdk8Test {
    final static String RANDOM_CHARS = "0123456789";

    @Test
    public void testString() {
        String userIds = "1,2;3,4;5, ,  ;6";
        log.info("userIds:{}", userIds);
        String formatUserIds = ValidationUtil.filterNumbers(userIds);
        log.info("formatUserIds:{}", formatUserIds);
        Assert.assertTrue(formatUserIds, ValidationUtil.validateNumbers(formatUserIds));
        List<String> userIdStrList = Arrays.asList(formatUserIds.split(",|;"));
        log.info("userIdStrList:{}", userIdStrList);
        List<Long> userIdList = userIdStrList.stream().map(userId -> Long.valueOf(userId)).collect(Collectors.toList());
        log.info("userIdList:{}", userIdList);
        assert true;
    }

    @Test
    public void wechatContent() {
        String userId = String.valueOf(50963791);
        String content = AesUtil.encryptAndBase64Encode(userId, Constants.AES_KEY);
        log.info("50963791:{}", content);
    }

    @Test
    public void uuid() {
        String uuid = UUID.randomUUID().toString();
        log.info("uuid:{}", uuid);
    }

    @Test
    public void random() {
        for(int i=0; i<10; i++){
            log.info("{}-random:{}", i, RandomStringUtils.random(6, RANDOM_CHARS));
        }
    }

}
