package cn.quantgroup.xyqb.entity;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by FrankChow on 15/7/8.
 */
@Entity
@Table(name = "channel", uniqueConstraints = @UniqueConstraint(columnNames = "channel_code"))
public class Channel implements Serializable {

  private static final long serialVersionUID = -1L;

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  //渠道代号
  @Column(name = "channel_code")
  private String channelCode;

  //渠道名称
  @Column(name = "name")
  private String name;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getChannelCode() {
    return channelCode;
  }

  public void setChannelCode(String channelCode) {
    this.channelCode = channelCode;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public String toString() {
    return "Channel{" +
        "channelCode='" + channelCode + '\'' +
        ", id=" + id +
        ", name='" + name + '\'' +
        '}';
  }
}
