package cn.quantgroup.xyqb.service.captcha.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.GeetestLib;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author xufei on 2018/1/30.
 */
@Service
public class GeetestCaptchaServiceImpl implements IGeetestCaptchaService {

    @Resource
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Value("${gt.server.status.exist.time}")
    private long gtServerStatusExistTime;

    @Value("${geetest.captcha.id}")
    private String captchaId;

    @Value("${geetest.private.key}")
    private String privateKey;

    @Value("${geetest.new.fail.back}")
    private boolean newFailback;

    @Value("${geetest.api.url}")
    private String apiUrl;

    @Override
    public Map<String, String> fetchGeetestCaptcha(String markStr, String remoteIp, ClientType clientType) {
        GeetestLib gtSdk = new GeetestLib(captchaId, privateKey, newFailback, apiUrl);
        HashMap<String, String> param = getParam(markStr, remoteIp, clientType);
        return gtSdk.getResponseStr(param);
    }

    @Override
    public boolean validGeetestCaptcha(ClientType clientType, String markStr, String remoteIp, String challenge, String validate, String seccode) {
        HashMap<String, String> param = getParam(markStr, remoteIp, clientType);
        return Constants.GT_CAPTCHA_VALIDATE_SUCCESS==getGeetestSdk().enhencedValidateRequest(challenge, validate, seccode, param);
    }

    private GeetestLib getGeetestSdk() {
        return new GeetestLib(captchaId, privateKey, newFailback, apiUrl);
    }

    private HashMap<String, String> getParam(String markStr, String remoteIp, ClientType clientType) {
        HashMap<String, String> param = new HashMap<>();
        param.put("user_id", markStr);
        if (Objects.isNull(clientType)) {
            param.put("client_type", ClientType.APP.name());
        }else{
            param.put("client_type", clientType.name());
        }
        param.put("ip_address", remoteIp);
        return param;
    }
}
