package cn.quantgroup.xyqb.event;

import org.springframework.context.ApplicationEvent;

import com.quantgroup.acolyte.buddhistscriptures.pojo.Login;
import com.quantgroup.acolyte.buddhistscriptures.pojo.Register;
import com.quantgroup.acolyte.buddhistscriptures.pojo.UserRealInfo;
import lombok.Getter;
import lombok.Setter;

/**
 * 统计事件
 *
 * @author renwc
 * @date 2018-06-26
 */
@Getter
@Setter
public class StatisticsEvent extends ApplicationEvent {
    /**
     * 登录统计
     */
    private Login login;
    /**
     * 注册统计
     */
    private Register register;
    /**
     * 实名统计
     */
    private UserRealInfo userRealInfo;

    /**
     * Create a new ApplicationEvent.
     *
     * @param source the object on which the event initially occurred (never {@code null})
     */
    public StatisticsEvent(Object source) {
        super(source);
    }
    public StatisticsEvent(Object source, Login login) {
        super(source);
        this.login = login;
    }
    public StatisticsEvent(Object source, Register register) {
        super(source);
        this.register = register;
    }
    public StatisticsEvent(Object source, UserRealInfo userRealInfo) {
        super(source);
        this.userRealInfo = userRealInfo;
    }

}
