package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.PushUserToLkbException;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.util.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

/**
 * 注册成功之后lkb
 *
 * @author ag
 */
@Slf4j
//@Component
public class LkbRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Autowired
    private ILkbUserService lkbUserService;

    //todo 这里重试机制补齐
    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        User user = userRegisterParam.getUser();
        String uuid = user.getUuid();
        boolean pushResult = lkbUserService.pushUser(uuid, userRegisterParam.getPhoneNo(),
                userRegisterParam.getName());
        if (!pushResult) {
            log.error("[userRegisterHandler][baseUserRegisterHandler]同步用户至Lkb出错,userRegisterParam:{}", JsonUtil.toJson(userRegisterParam));
            throw new PushUserToLkbException("同步用户至Lkb出错");
        }
    }
}
